import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define colors for the tiles and robots
clear_tile_color = 'lightgreen'
occupied_tile_color = 'lightcoral'
robot1_color = 'white'
robot2_color = 'black'
text_color = 'black'

# Define grid size
rows, cols = 5, 4
tile_size = 1

# Draw the grid of tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        if (row == 1 and col in [0, 1]):
            color = occupied_tile_color
        else:
            color = clear_tile_color
        rect = patches.Rectangle((col * tile_size, row * tile_size), tile_size, tile_size,
                                 linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col * tile_size + tile_size / 2, row * tile_size + tile_size / 2, tile_id,
                color=text_color, ha='center', va='center', fontsize=8, weight='bold')

# Draw the robots
robot1 = patches.Circle((0.5 * tile_size, 1.5 * tile_size), 0.3, color=robot1_color, ec='black')
ax.add_patch(robot1)
ax.text(0.5 * tile_size, 1.5 * tile_size, 'robot1\nwhite', color=text_color, ha='center', va='center', fontsize=6, weight='bold')

robot2 = patches.Circle((1.5 * tile_size, 1.5 * tile_size), 0.3, color=robot2_color, ec='black')
ax.add_patch(robot2)
ax.text(1.5 * tile_size, 1.5 * tile_size, 'robot2\nblack', color='white', ha='center', va='center', fontsize=6, weight='bold')

# Set limits and remove axes for a clean look
ax.set_xlim(0, cols * tile_size)
ax.set_ylim(0, rows * tile_size)
ax.set_aspect('equal')
ax.axis('off')

# Add a legend to describe the color coding
legend_labels = ['Clear Tile', 'Occupied/Not Clear Tile', 'Robot1 (White)', 'Robot2 (Black)']
legend_colors = [clear_tile_color, occupied_tile_color, robot1_color, robot2_color]
legend_patches = [patches.Patch(color=lc, label=ll) for lc, ll in zip(legend_colors, legend_labels)]
ax.legend(handles=legend_patches, loc='upper right', bbox_to_anchor=(1.2, 1), fontsize=8)

# Save the figure to a file
plt.savefig('tiles/one_shot/ini_diagram_code/attempts/attempt_28.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# The legend overlaps with the grid, and the labels inside the robots are not clearly readable.
